///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD WINAPI TCPThreadFunction(LPVOID pvThread)
{
	Server* pServer = (Server*) pvThread;  //typecast

	pServer->TimeOut.tv_sec	= 5;
	pServer->TimeOut.tv_usec = 250;

	FD_ZERO(&pServer->ReadFDS);
	FD_ZERO(&pServer->WriteFDS);
	FD_ZERO(&pServer->ExceptFDS);

	int xClient = 0;

    char StatusText[1024];

    DWORD CurrentTime = 0;

	while(1)
	{
        if(gbEnableGlobalTimeOut)
        {
            SYSTEMTIME ST;
            GetLocalTime(&ST);
            CurrentTime = TimeToLong(ST.wHour, ST.wMinute, ST.wSecond);
        }

        if(pServer->Connections < 0)
        {
            sprintf(StatusText, "Error in TCPThreadFunction: Connections = %d .", pServer->Connections);
            FatalError(StatusText);
            exit(1);
        }

		// Set LocalListenSocket socket to Read, Except
		FD_SET(pServer->LocalListenSocket, &pServer->ReadFDS);
		FD_SET(pServer->LocalListenSocket, &pServer->ExceptFDS);

		// Set all connected clients to Read, Write, Except
		xClient = 0;
		while(xClient < MAXCLIENTS)
		{
			if( pServer->Connected[xClient] == true)
			{
				FD_SET(pServer->Socket[xClient], &pServer->ReadFDS);
				FD_SET(pServer->Socket[xClient], &pServer->WriteFDS);
				FD_SET(pServer->Socket[xClient], &pServer->ExceptFDS);
			}
			xClient++;
		}

		// Socket Select...
		if(select(-1, &pServer->ReadFDS, &pServer->WriteFDS, &pServer->ExceptFDS, &pServer->TimeOut) == SOCKET_ERROR)
		{
			// TCPThreadFunction- Socket error.
			return -1;
		}

		// Are there incoming connections? If so, Accept them.
		pServer->AcceptConnection();

		// Are any clients ready to send or receive data? If so send/receive their data.
		xClient = 0;
		if(pServer->Connections > 0)
		{
			while(xClient < MAXCLIENTS)
			{
				if( pServer->Connected[xClient] == true)
				{
					pServer->DoSendData(xClient);
					pServer->DoReceiveData(xClient);

                    if(gbEnableGlobalTimeOut)
                    {
                        if(CurrentTime >= pServer->DisconnectTime[xClient] && pServer->DisconnectTime[xClient] != -1)
                        {
                            sprintf(StatusText, "(%d) Connection timed out.", pServer->ClientID[xClient]);
                            WriteLog(StatusText);
                            pServer->Disconnect[xClient] = true;
                        }
                    }

    				if( pServer->Disconnect[xClient] == true)
                    {
                        pServer->DisconnectClient(xClient);
                    }
                }

				xClient++;
			}
		}

    	Sleep(glTCPLoopDelay);
	}

	return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool Server::CreateNewTCPThread(void)
{
    TCPThreadHandle = CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE)TCPThreadFunction, (LPVOID) this, 0, (LPDWORD) &TCPThreadID);

    if(TCPThreadHandle == NULL)
        return false;

    TCPThreadActive = true;
    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool Server::SuspendTCPThread(void)
{
    if(!TCPThreadActive) return false;
	TCPThreadActive = false;
	return(-1 != SuspendThread(TCPThreadHandle));
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool Server::KillTCPThread(void)
{
	return(-1 != TerminateThread(TCPThreadHandle, 1));
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool Server::ResumeTCPThread(void)
{
    if(TCPThreadActive) return false;
	TCPThreadActive = true;
	return(-1 != ResumeThread(TCPThreadHandle));
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool Server::IsTCPThreadActive(void)
{
	return TCPThreadActive;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
